﻿using System.Web.Mvc;
using System;
using PartyInvites.Models;

namespace PartyInvites.Controllers
{

    public class HomeController : Controller
    {

        public ViewResult Index() { 
 
            int hour = DateTime.Now.Hour; 
            ViewData["greeting"] = hour < 17 ? "Dzień dobry" : "Dobry wieczór"; 
            return View(); 
        } 
 
        [HttpGet]
        public ViewResult RsvpForm() { 
            return View(); 
        }

        [HttpPost]
        public ViewResult RsvpForm(GuestResponse guestResponse) {
            if (ModelState.IsValid) {
                // Do zrobienia: wyślij zawartość guestResponse do organizatora przyjęcia.
                return View("Thanks", guestResponse);
            }
            else // Błąd kontroli poprawności, więc ponownie wyświetlamy formularz wprowadzania danych.
                return View();
            }
        }


}
